<?php
/*
 * Copyright MADE/YOUR/DAY OG <mail@madeyourday.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace MadeYourDay\RockSolidCustomElements\Widget;

use Contao\Widget;

/**
 * List stop widget
 *
 * @author Martin Auswöger <martin@madeyourday.net>
 */
class ListStop extends Widget
{
	/**
	 * @var boolean Submit user input
	 */
	protected $blnSubmitInput = false;

	/**
	 * @var string Template
	 */
	protected $strTemplate = 'be_rsce_list';

	/**
	 * Generate the widget and return it as string
	 *
	 * @return string
	 */
	public function generate()
	{
		return '<script>'
			. 'rsceInitList(\'pal_' . substr($this->strId, 0, -5) . '_start\');'
			. '</script>'
			. '</fieldset><fieldset class="tl_box rsce_list_stop">';
	}
}
